/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.item;

import java.util.Collection;
import java.util.List;
import mod.chiselsandbits.api.exceptions.SealingNotSupportedException;
import mod.chiselsandbits.api.item.multistate.IMultiStateItemStack;
import mod.chiselsandbits.api.item.pattern.IMultiUsePatternItem;
import mod.chiselsandbits.api.item.pattern.IPatternItem;
import mod.chiselsandbits.api.item.withmode.group.IToolModeGroup;
import mod.chiselsandbits.api.multistate.mutator.IMutatorFactory;
import mod.chiselsandbits.api.multistate.mutator.world.IWorldAreaMutator;
import mod.chiselsandbits.api.multistate.snapshot.IMultiStateSnapshot;
import mod.chiselsandbits.api.notifications.INotificationManager;
import mod.chiselsandbits.api.pattern.placement.IPatternPlacementType;
import mod.chiselsandbits.api.pattern.placement.PlacementResult;
import mod.chiselsandbits.api.util.HelpTextUtils;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.item.multistate.SingleBlockMultiStateItemStack;
import mod.chiselsandbits.multistate.snapshot.EmptySnapshot;
import mod.chiselsandbits.registrars.ModItems;
import mod.chiselsandbits.registrars.ModPatternPlacementTypes;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleUsePatternItem
extends class_1792
implements IPatternItem {
    public SingleUsePatternItem(class_1792.class_1793 builder) {
        super(builder);
    }

    @NotNull
    public class_2561 method_7864(class_1799 item) {
        if (!item.method_7948().method_10545("highlight")) {
            return super.method_7864(item);
        }
        String highlightTextJson = item.method_7948().method_10558("highlight");
        return class_2561.class_2562.method_10877((String)highlightTextJson).method_27692(class_124.field_1061);
    }

    @Override
    @NotNull
    public IMultiStateItemStack createItemStack(class_1799 stack) {
        if (stack.method_7948().method_33133()) {
            return EmptySnapshot.Stack.INSTANCE;
        }
        return new SingleBlockMultiStateItemStack(stack);
    }

    @NotNull
    public class_1269 method_7884(@NotNull class_1838 context) {
        IMultiStateItemStack contents = this.createItemStack(context.method_8041());
        if (contents.getStatistics().isEmpty()) {
            if (context.method_8036() == null) {
                return class_1269.field_5814;
            }
            if (!context.method_8036().method_7337()) {
                return class_1269.field_5814;
            }
            if (!context.method_8036().method_18276()) {
                return class_1269.field_5814;
            }
            IWorldAreaMutator areaMutator = IMutatorFactory.getInstance().in((class_1936)context.method_8045(), context.method_8037());
            class_1799 snapshotPatternStack = areaMutator.createSnapshot().toItemStack().toPatternStack();
            context.method_8041().method_7980(snapshotPatternStack.method_7948().method_10553());
            return class_1269.field_5812;
        }
        return this.tryPlace(new class_1750(context));
    }

    @NotNull
    public class_1269 tryPlace(@NotNull class_1750 context) {
        if (context.method_8036() == null) {
            return class_1269.field_5814;
        }
        IMultiStateItemStack source = this.createItemStack(context.method_8041());
        IMultiStateSnapshot sourceSnapshot = source.createSnapshot();
        IPatternPlacementType mode = this.getMode(context.method_8041());
        PlacementResult resultType = mode.performPlacement(sourceSnapshot, context, false);
        if (!resultType.isSuccess() && context.method_8045().method_8608()) {
            INotificationManager.getInstance().notify(mode.getIcon(), new class_243(1.0, 0.0, 0.0), resultType.getFailureMessage());
        }
        return resultType.isSuccess() ? this.determineSuccessResult(context, context.method_8041()) : class_1269.field_5814;
    }

    protected class_1269 determineSuccessResult(class_1750 context, class_1799 stack) {
        if (context.method_8036() != null && context.method_8036().method_7337()) {
            return class_1269.field_5812;
        }
        stack.method_7934(1);
        return class_1269.field_21466;
    }

    @Override
    @NotNull
    public class_1799 seal(@NotNull class_1799 source) throws SealingNotSupportedException {
        if (source.method_7909() == this) {
            if (!(source.method_7909() instanceof IMultiUsePatternItem)) {
                class_1799 seal = new class_1799((class_1935)ModItems.MULTI_USE_PATTERN_ITEM.get());
                seal.method_7980(source.method_7948().method_10553());
                return seal;
            }
            throw new SealingNotSupportedException();
        }
        return source;
    }

    public void method_7851(@NotNull class_1799 stack, @Nullable class_1937 worldIn, @NotNull List<class_2561> tooltip, @NotNull class_1836 flagIn) {
        IPatternPlacementType mode = this.getMode(stack);
        if (mode.getGroup().isPresent()) {
            tooltip.add((class_2561)LocalStrings.PatternItemTooltipModeGrouped.getText(((IToolModeGroup)mode.getGroup().get()).getDisplayName(), mode.getDisplayName()));
        } else {
            tooltip.add((class_2561)LocalStrings.PatternItemTooltipModeSimple.getText(mode.getDisplayName()));
        }
        if (class_310.method_1551().method_22683() != null && class_437.method_25442()) {
            tooltip.add((class_2561)new class_2585("        "));
            tooltip.add((class_2561)new class_2585("        "));
            HelpTextUtils.build(LocalStrings.HelpSimplePattern, tooltip, new Object[0]);
        }
    }

    @Override
    @NotNull
    public IPatternPlacementType getMode(class_1799 stack) {
        return ModPatternPlacementTypes.REGISTRY_SUPPLIER.get().get(stack.method_7948().method_10545("mode") ? new class_2960(stack.method_7948().method_10558("mode")) : ModPatternPlacementTypes.PLACEMENT.getId()).orElse(ModPatternPlacementTypes.PLACEMENT.get());
    }

    @Override
    public void setMode(class_1799 stack, IPatternPlacementType mode) {
        stack.method_7948().method_10582("mode", mode.getRegistryName().toString());
    }

    @Override
    @NotNull
    public Collection<IPatternPlacementType> getPossibleModes() {
        return ModPatternPlacementTypes.REGISTRY_SUPPLIER.get().getValues();
    }
}

